<?php

namespace Modules\Training\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Training extends Model 
{

    protected $table = 'trainings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'thumbnail', 'preview', 'description', 'location', 'overall_rating', 'price', 'is_online');

    public function training_schedule()
    {
        return $this->hasMany('TrainingSchedule');
    }

}